﻿using System;
using System.ComponentModel;
using System.Web.UI.WebControls.WebParts;
using Microsoft.SharePoint;
using System.Text;

namespace GSD.ChartWithC3_JS.GSD_ChartWithC3_JS
{
    [ToolboxItemAttribute(false)]
    public partial class GSD_ChartWithC3_JS : WebPart
    {
        public GSD_ChartWithC3_JS() { }

        protected override void OnInit(EventArgs e) { base.OnInit(e); InitializeControl(); }

        protected void Page_Load(object sender, EventArgs e)
        {
            using (SPSite site = new SPSite(SPContext.Current.Web.Url))
            {
                using (SPWeb web = site.OpenWeb())
                {
                    string data = string.Empty;
                    for (int i = 0; i < projetos.Length; i++)
                    {
                        SPQuery query = new SPQuery();
                        query.Query = Query(projetos[i]);
                        SPListItemCollection items = web.Lists["Projetos"].GetItems(query);
                        data = data + "," + GenerateData(items, projetos[i]);
                        hfdDados.Value = data.Remove(0, 1);
                    }
                }
            }
            hfdTipo.Value = "bar";
            hfdMes.Value = "['x', 'Janeiro', 'Fevereiro', 'Março']";
        }

        //Query CAML usada para busca os items por versao 
        private string Query(string versao)
        {
            return
                  string.Format(@"<Where>
                                    <Eq>
                                        <FieldRef Name='Versao' />
                                        <Value Type='Text'>{0}</Value>
                                    </Eq>
                                </Where>
                                <OrderBy>
                                    <FieldRef Name='Mes' Ascending='True' />
                                </OrderBy>", versao);
        }

        //Array de Tecnologia cadastradas na lista do SharePoint
        private string[] projetos = new string[] { "SP 2010", "SP 2013", "Dynamics CRM" };

        //Esse método gera os dados no formato exigido pelo C3, obs: C3 aceita vários formatos de dados....
        private string GenerateData(SPListItemCollection items, string projeto)
        {
            StringBuilder data = new StringBuilder();
            data.Append("['" + projeto + "'");
            for (int i = 0; i < items.Count; i++)
            {
                data.Append(",");
                data.Append(items[i]["Horas"].ToString());
            }
            data.Append("]");

            return data.ToString();
        }
    }
}
